// normally the model is passed to the view instead of the view creating the model
define(
    [
        'backbone',
        'marionette',
        'modules/notification-preferences/notification-preferences-module',
        'modules/form/section-view',
        'text!modules/form/section-with-heading.html',
        'json!modules/preferences/email-preferences-form.json',
    ],
    function(Backbone, Marionette,
        module,
        SectionView,
        template,
        metadata) {
        'use strict';
        return SectionView.extend({
            template: template,
            modelEvents: {'change:emailAllowed': 'updatePreferencesAndForm'},

            initialize: function(options) {
                var sectionName = 'email-preferences-section';
                this.isForCommunityCare = options.isForCommunityCare || false;
                this.legend = this.getLegendFromMetadata(sectionName, metadata, false) || '';
                this.collection = this.getQuestionsFromMetadata(sectionName, metadata, options);

                // initialize listener to 'change:value' after static values are set
                this.initializeQuestionEventListeners();
                this.validator = options.validator;
            },

            updateQuestionValuesAndRender: function(notificationPreferences) {
                if (!this.isDestroyed()) {
                    this.collection.each(function(question) {
                        question.set('value', notificationPreferences.get(question.get('id')));
                    }, this);
                    this.render();

                    this.initChildren();
                    this.showHideChildrenQuestionsAndValidation();
                }
            },

            onRender: function() {
                this.initChildren();
                this.showHideChildrenQuestionsAndValidation();

                this.listenTo(module.notificationPreferences, 'sync', this.updateQuestionValuesAndRender);
            },

            updatePreferencesAndForm: function() {
                this.updateEmailPrefsModel();
                this.showHideChildrenQuestionsAndValidation();
            },

            updateEmailPrefsModel: function() {
                var notificationFrequency = this.model.get('emailAllowed') ? 'Each new message' : 'Never';
                this.model.set('notificationFrequency', notificationFrequency);
            },

            showHideChildrenQuestionsAndValidation: function() {
                var children;

                if (!this.isDestroyed() && !this.isForCommunityCare) {
                    children = this.$el.find('.email-address-question');
                    children.toggleClass('hidden', !this.model.get('emailAllowed'));
                    if (!this.model.get('emailAllowed')) {
                        this.hideValidationErrorsFor(children);
                    }
                }
            },
        });
    });
